/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.ComponentModel;
using System.Windows.Forms;
using Borland.Eco.Handles;

namespace Borland.Eco.WinForm
{
	#region TextBox MaxLengthProvider
	[MaxLengthSupportProvider(typeof(TextBox))]
	public class TextBoxMaxLengthSupportProvider : IMaxLengthSupportProvider
	{
		public TextBoxMaxLengthSupportProvider()
		{
		}

		public void SetMaxLength(object obj)
		{
			System.Diagnostics.Debug.Assert(obj != null);
			TextBox textBox = obj as TextBox;
			System.Diagnostics.Debug.Assert(textBox != null);
			
			Binding binding = textBox.DataBindings["Text"];
			if (binding != null && binding.DataSource is ElementHandle)
			{
				ElementHandle handle = binding.DataSource as ElementHandle;
				PropertyDescriptorCollection pdc = (handle as ITypedList).GetItemProperties(null);
				RenderedTuplePropertyDescriptor prop = pdc.Find(binding.BindingMemberInfo.BindingField, true) as RenderedTuplePropertyDescriptor;
				textBox.ReadOnly = prop.IsReadOnly;
				textBox.MaxLength = MaxLengthSupportFunctions.GetMaxLength(prop, handle, textBox.MaxLength);
			}
		}
	}
	#endregion

	#region DataGrid MaxLengthProvider
	[MaxLengthSupportProvider(typeof(DataGrid))]
	public class DataGridMaxLengthSupportProvider : IMaxLengthSupportProvider
	{
		public DataGridMaxLengthSupportProvider()
		{
		}

		private static AbstractColumn ColumnByName(ElementHandle handle, string columnName)
		{
			for (int columnIndex = 0; columnIndex < handle.Columns.Count; columnIndex++)
				if (handle.Columns[columnIndex].Name == columnName)
					return handle.Columns[columnIndex];
			return null;
		}

		public void SetMaxLength(DataGridColumnStyle columnStyle, ElementHandle handle)
		{
			if (columnStyle == null) return;
			DataGridTextBoxColumn textColumn = columnStyle as DataGridTextBoxColumn;
			if (textColumn != null)
			{
				if (columnStyle.PropertyDescriptor is RenderedTuplePropertyDescriptor)
				{
					RenderedTuplePropertyDescriptor prop = columnStyle.PropertyDescriptor as RenderedTuplePropertyDescriptor;
					textColumn.ReadOnly = prop.IsReadOnly;
					textColumn.TextBox.MaxLength = MaxLengthSupportFunctions.GetMaxLength(prop, handle, textColumn.TextBox.MaxLength);
				}
				else
				{
					AbstractColumn col = ColumnByName(handle, columnStyle.MappingName);
					if (col != null)
						textColumn.TextBox.MaxLength = MaxLengthSupportFunctions.GetMaxLength(col.Expression, handle, textColumn.TextBox.MaxLength);
				}
			}
		}

		public void SetMaxLength(object obj)
		{
			System.Diagnostics.Debug.Assert(obj != null);
			System.Diagnostics.Debug.Assert(obj is DataGrid);

			DataGrid dataGrid = (DataGrid) obj;
			ElementHandle handle = dataGrid.DataSource as ElementHandle;
			if (handle != null)
			{
				// if there is no tablestyle, we can not access the
				// default columns
				if (dataGrid.TableStyles.Count == 0)
				{
					// reset the Datasource to force the grid
					// to assign its ListManager
					// this only happens if this code is executed "too early"
					dataGrid.DataSource = null;
					dataGrid.DataSource = handle;

					DataGridTableStyle tableStyle = new DataGridTableStyle(true);
					dataGrid.TableStyles.Add(tableStyle);
				}

				foreach (DataGridTableStyle tableStyle in dataGrid.TableStyles)
					foreach (DataGridColumnStyle columnStyle in tableStyle.GridColumnStyles)
						SetMaxLength(columnStyle, handle);
			}
		}
	}
	#endregion
}
